/*
 * Decompiled with CFR 0.152.
 */
import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvValidationException;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import org.jsoup.HttpStatusException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

class CommandsFileGenerator {
    static OSType detectedOS = null;
    static String fileSeparator = File.separator;
    static String dataSource = "";
    static String fileSource = "";
    static String albumDirectory = "";
    static String imagesDirectory = "";
    static String albumName = "";
    static String albumFileName = "";
    static String extractFileName = "";
    static String exportFileName = "";
    static String siteName = "";
    static String catalogName = "";
    static boolean noImages = false;
    static boolean fixSizes = false;
    static boolean noSSLCheck = false;
    static String separator = "@";
    static int rowsWritten = 0;
    static int stampsWritten = 0;
    static int usedWidth = 0;
    static int usedHeight = 0;
    static int maxRowHeight = 0;
    static int sequencer = 0;
    static int startYear = 0;
    static int endYear = 9999;
    static List<String> formats = new ArrayList<String>();
    static List<String> emissions = new ArrayList<String>();
    static List<String> currencies = new ArrayList<String>();
    static AffineTransform affinetransform = new AffineTransform();
    static FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
    static Font font = new Font("Times New Roman", 0, 6);
    static String[] monthNames = new String[]{"?????", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    static String[] validFormats = new String[]{"Booklet", "Booklet Pane", "Full Pane", "Gutter Pairs", "Mini Sheet", "Se-tenant", "Souvenir Sheet", "Stamp", "Stamp with Attached Label", "Stamp with Collectible Margin", "Tete-beche", "Unknown"};
    static String[] validEmissions = new String[]{"Agency Issue", "Air Post", "Air Post Official", "Air Post Semi-Postal", "ATM Labels", "Cinderella", "Commemorative", "Cryptostamp", "Definitive", "Erinnophilia", "Forgery", "Franchise Stamps", "Hunting Permit", "Illegal", "Insured Letter", "Military", "Newspaper", "Official", "Official Reprint", "Other", "Parcel Post", "Personal Delivery", "Personalized - Official", "Personalized - Private", "Postage Due", "Postal Fiscal", "Postal Tax", "Precancelled", "Private", "Proof", "Regional", "Registration", "Revenue", "Savings Stamps", "Semi-Postal", "Special Delivery", "Specimen", "Telegraph & Telephone", "Used Abroad", "War Tax"};

    CommandsFileGenerator() {
    }

    public static void main(String[] stringArray) throws IOException {
        int n;
        int n2;
        Object object;
        File file;
        detectedOS = CommandsFileGenerator.getOperatingSystemType();
        if (detectedOS != OSType.Windows && detectedOS != OSType.MacOS && detectedOS != OSType.Linux) {
            System.out.println("Unsupported operating system");
            System.exit(1);
        }
        if (stringArray.length < 1) {
            System.out.println("USAGE1 : java -jar CommandsFileGenerator.jar <stampworld|touchstamps> <album name> <source> <directory> [options]");
            System.out.println("EXAMPLE: java -jar CommandsFileGenerator.jar stampworld \"United Nations New York\" UN-New-York albums");
            System.out.println("USAGE2 : java -jar CommandsFileGenerator.jar colnectexport <album name> <export file path> [options]");
            System.out.println("EXAMPLE: java -jar CommandsFileGenerator.jar colnectexport \"United Nations New York\" UN_New_York_export.csv");
            System.out.println("USAGE3 : java -jar CommandsFileGenerator.jar extractfile <album name> <extract file path> [options]");
            System.out.println("EXAMPLE: java -jar CommandsFileGenerator.jar extractfile \"United Nations New York\" UN_New_York_export.txt");
            System.exit(1);
        } else if (stringArray.length < 2) {
            System.out.println("Missing album name");
            System.exit(1);
        }
        if (stringArray[0].compareToIgnoreCase("stampworld") != 0 && stringArray[0].compareToIgnoreCase("touchstamps") != 0 && stringArray[0].compareToIgnoreCase("extractfile") != 0 && stringArray[0].compareToIgnoreCase("colnectexport") != 0) {
            System.out.println("Valid sources are stampworld, touchstamps, extractfile, and colnectexport");
            System.exit(1);
        }
        dataSource = stringArray[0];
        albumName = stringArray[1];
        if (stringArray[0].compareToIgnoreCase("stampworld") == 0 || stringArray[0].compareToIgnoreCase("touchstamps") == 0) {
            if (stringArray.length < 3) {
                System.out.println("Missing site country name");
                System.exit(1);
            } else if (stringArray.length < 4) {
                System.out.println("Missing album root directory");
                System.exit(1);
            }
            siteName = stringArray[2];
            albumDirectory = stringArray[3] + fileSeparator + siteName.replaceAll("/", "-");
            imagesDirectory = albumDirectory + "/images";
            albumFileName = albumDirectory + fileSeparator + albumName.replaceAll(" ", "_") + ".txt";
            extractFileName = albumDirectory + fileSeparator + siteName.replaceAll("/", "-") + "_extract.txt";
        } else if (stringArray[0].compareToIgnoreCase("extractfile") == 0) {
            extractFileName = stringArray[2];
            extractFileName = extractFileName.replaceAll("\\\\", "/");
            file = new File(extractFileName = extractFileName.replaceAll("//", "/"));
            if (!file.exists()) {
                System.out.println("Extract file not found");
                System.exit(1);
            }
            object = extractFileName.split("/");
            n2 = ((String[])object).length;
            n = object[((String[])object).length - 1].length();
            int n3 = extractFileName.length() - n;
            albumDirectory = n2 > 1 ? extractFileName.substring(0, n3 - 1) : ".";
            albumFileName = albumDirectory + fileSeparator + albumName.replaceAll(" ", "_") + ".txt";
            fileSource = CommandsFileGenerator.getFileSource(extractFileName);
            if (fileSource.compareToIgnoreCase("colnect") == 0) {
                catalogName = "All";
            } else if (fileSource.compareToIgnoreCase("stampworld") == 0) {
                catalogName = "Sw";
            } else if (fileSource.compareToIgnoreCase("touchstamps") == 0) {
                catalogName = "Ts";
            }
        } else if (stringArray[0].compareToIgnoreCase("colnectexport") == 0) {
            exportFileName = stringArray[2];
            extractFileName = extractFileName.replaceAll("\\\\", "/");
            extractFileName = extractFileName.replaceAll("//", "/");
            file = new File(exportFileName);
            if (!file.exists()) {
                System.out.println("Export file not found");
                System.exit(1);
            }
            object = exportFileName.split("/");
            n2 = ((String[])object).length;
            n = object[((String[])object).length - 1].length();
            int n4 = exportFileName.length() - n;
            albumDirectory = n2 > 1 ? exportFileName.substring(0, n4 - 1) : ".";
            imagesDirectory = albumDirectory + "/images";
            albumFileName = albumDirectory + fileSeparator + albumName.replaceAll(" ", "_") + ".txt";
            extractFileName = albumDirectory + fileSeparator + albumName.replaceAll(" ", "_") + "_extract.txt";
            fileSource = "colnect";
        }
        int n5 = 0;
        if (stringArray[0].compareToIgnoreCase("colnect") == 0 || stringArray[0].compareToIgnoreCase("stampworld") == 0 || stringArray[0].compareToIgnoreCase("touchstamps") == 0) {
            n5 = 4;
        } else if (stringArray[0].compareToIgnoreCase("extractfile") == 0 || stringArray[0].compareToIgnoreCase("colnectexport") == 0) {
            n5 = 3;
        }
        if (!CommandsFileGenerator.checkOptions(stringArray, n5)) {
            System.exit(1);
        }
        if (!(stringArray[0].compareToIgnoreCase("extractfile") != 0 && stringArray[0].compareToIgnoreCase("colnectexport") != 0 || startYear <= 0 && endYear >= 9999)) {
            System.out.println("Start and end year options may only be used with Touchstamps and Stampworld sources");
            System.exit(1);
        }
        if (stringArray[0].compareToIgnoreCase("colnect") == 0 || stringArray[0].compareToIgnoreCase("stampworld") == 0 || stringArray[0].compareToIgnoreCase("touchstamps") == 0) {
            File file2;
            File file3;
            object = new File(stringArray[3]);
            if (!((File)object).exists()) {
                ((File)object).mkdir();
            }
            if (!(file3 = new File(albumDirectory)).exists()) {
                file3.mkdir();
            }
            if (!(file2 = new File(imagesDirectory)).exists()) {
                file2.mkdir();
            }
        } else if (stringArray[0].compareToIgnoreCase("colnectexport") == 0 && !((File)(object = new File(imagesDirectory))).exists()) {
            ((File)object).mkdir();
        }
        object = new CommandsFileGenerator();
        List<String> list = null;
        if (dataSource.compareToIgnoreCase("colnect") == 0) {
            if (catalogName.compareTo("") == 0) {
                catalogName = "All";
            }
            String string = "https://colnect.com/en/stamps/list/country/" + siteName;
            list = ((CommandsFileGenerator)object).collectColnectData(string);
            Collections.sort(list);
            ((CommandsFileGenerator)object).saveStampData(extractFileName, list, "colnect");
        } else if (dataSource.compareToIgnoreCase("stampworld") == 0) {
            catalogName = "Sw";
            String string = "https://www.stampworld.com/en/stamps/" + stringArray[2] + "/?page=";
            list = ((CommandsFileGenerator)object).collectStampworldData(string);
            Collections.sort(list);
            ((CommandsFileGenerator)object).saveStampData(extractFileName, list, "stampworld");
        } else if (dataSource.compareToIgnoreCase("touchstamps") == 0) {
            catalogName = "Ts";
            String string = "https://touchstamps.com/Catalogues/" + stringArray[2];
            list = ((CommandsFileGenerator)object).collectTouchstampsData(string);
            Collections.sort(list);
            ((CommandsFileGenerator)object).saveStampData(extractFileName, list, "touchstamps");
        } else if (dataSource.compareToIgnoreCase("extractfile") == 0) {
            list = ((CommandsFileGenerator)object).getDataFromFile(extractFileName);
        } else if (dataSource.compareToIgnoreCase("colnectexport") == 0) {
            list = ((CommandsFileGenerator)object).getDataFromExport(exportFileName);
            Collections.sort(list);
            ((CommandsFileGenerator)object).saveStampData(extractFileName, list, "colnect");
        }
        ((CommandsFileGenerator)object).createAlbum(albumFileName, list);
    }

    public static boolean checkOptions(String[] stringArray, int n) {
        boolean bl = true;
        if (stringArray.length > n) {
            for (int i = n; i < stringArray.length; ++i) {
                int n2;
                String[] stringArray2;
                if (stringArray[i].toLowerCase().startsWith("catalog:")) {
                    if (dataSource.compareToIgnoreCase("colnect") == 0 || fileSource.compareToIgnoreCase("colnect") == 0) {
                        stringArray2 = stringArray[i].split(":");
                        if (stringArray2.length < 2) {
                            System.out.println("Invalid catalog option " + stringArray[i] + "\nMust be of the form 'catalog:catalog id'");
                            bl = false;
                            continue;
                        }
                        if (stringArray2[1].compareToIgnoreCase("Mi") == 0 || stringArray2[1].compareToIgnoreCase("Sg") == 0 || stringArray2[1].compareToIgnoreCase("Sn") == 0 || stringArray2[1].compareToIgnoreCase("Yt") == 0) {
                            catalogName = stringArray2[1] + ":";
                            catalogName = catalogName.substring(0, 1).toUpperCase() + catalogName.substring(1).toLowerCase();
                            continue;
                        }
                        System.out.println("Invalid catalog name " + stringArray2[1]);
                        System.out.println("Valid catalog ids are Mi Sg Sn and Yt");
                        bl = false;
                        continue;
                    }
                    System.out.println("Catalog option only valid for colnect");
                    bl = false;
                    continue;
                }
                if (stringArray[i].toLowerCase().startsWith("format:")) {
                    if (dataSource.compareToIgnoreCase("colnect") == 0 || fileSource.compareToIgnoreCase("colnect") == 0 || dataSource.compareToIgnoreCase("touchstamps") == 0 || fileSource.compareToIgnoreCase("touchstamps") == 0) {
                        stringArray2 = stringArray[i].split(":");
                        if (stringArray2.length < 2) {
                            System.out.println("Invalid format option " + stringArray[i] + "\nMust be of the form 'format:format id'");
                            bl = false;
                            continue;
                        }
                        if (CommandsFileGenerator.isValidFormat(stringArray2[1])) {
                            formats.add(stringArray2[1]);
                            continue;
                        }
                        System.out.println("Invalid format " + stringArray2[1]);
                        System.out.print("Valid formats are ");
                        for (n2 = 0; n2 < validFormats.length; ++n2) {
                            System.out.print("'" + validFormats[n2] + "' ");
                        }
                        System.out.println();
                        bl = false;
                        continue;
                    }
                    System.out.println("Format option only valid for colnect and touchstamps");
                    bl = false;
                    continue;
                }
                if (stringArray[i].toLowerCase().startsWith("emission:")) {
                    if (dataSource.compareToIgnoreCase("colnect") == 0 || fileSource.compareToIgnoreCase("colnect") == 0 || dataSource.compareToIgnoreCase("touchstamps") == 0 || fileSource.compareToIgnoreCase("touchstamps") == 0) {
                        stringArray2 = stringArray[i].split(":");
                        if (stringArray2.length < 2) {
                            System.out.println("Invalid emission option " + stringArray[i] + "\nMust be of the form 'emission:emission id'");
                            bl = false;
                            continue;
                        }
                        if (CommandsFileGenerator.isValidEmission(stringArray2[1])) {
                            emissions.add(stringArray2[1]);
                            continue;
                        }
                        System.out.println("Invalid  emission " + stringArray2[1]);
                        System.out.print("Valid emissions are ");
                        for (n2 = 0; n2 < validEmissions.length; ++n2) {
                            System.out.print("'" + validEmissions[n2] + "' ");
                        }
                        System.out.println();
                        bl = false;
                        continue;
                    }
                    System.out.println("Emission option only valid for colnect and touchstamps");
                    bl = false;
                    continue;
                }
                if (stringArray[i].toLowerCase().startsWith("currency:")) {
                    stringArray2 = stringArray[i].split(":");
                    if (stringArray2.length < 4) {
                        System.out.println("Invalid currency option " + stringArray[i] + "\nMust be of the form 'currency:currency name:currency symbol:[pre|post]'");
                        bl = false;
                        continue;
                    }
                    if (stringArray2[3].compareToIgnoreCase("pre") != 0 && stringArray2[3].compareToIgnoreCase("post") != 0) {
                        System.out.println("Invalid currency position " + stringArray2[3] + "\nCurrency position (fourth element) must be pre or post");
                        bl = false;
                        continue;
                    }
                    currencies.add(stringArray[i].replaceAll("\"", ""));
                    continue;
                }
                if (stringArray[i].toLowerCase().startsWith("startyear:")) {
                    stringArray2 = stringArray[i].split(":");
                    if (stringArray2.length < 2) {
                        System.out.println("Invalid start year option " + stringArray[i] + "\nMust be of the form 'startYear:yyyy'");
                        bl = false;
                        continue;
                    }
                    if (CommandsFileGenerator.isValidYear(stringArray2[1])) {
                        startYear = Integer.parseInt(stringArray2[1]);
                        continue;
                    }
                    System.out.println("Invalid  start year " + stringArray2[1]);
                    System.out.println("start year must be a positive number");
                    bl = false;
                    continue;
                }
                if (stringArray[i].toLowerCase().startsWith("endyear:")) {
                    stringArray2 = stringArray[i].split(":");
                    if (stringArray2.length < 2) {
                        System.out.println("Invalid end year option " + stringArray[i] + "\nMust be of the form 'endYear:yyyy'");
                        bl = false;
                        continue;
                    }
                    if (CommandsFileGenerator.isValidYear(stringArray2[1])) {
                        endYear = Integer.parseInt(stringArray2[1]);
                        continue;
                    }
                    System.out.println("Invalid  end year " + stringArray2[1]);
                    System.out.println("end year must be a positive number");
                    bl = false;
                    continue;
                }
                if (stringArray[i].compareToIgnoreCase("noImages") == 0) {
                    noImages = true;
                    continue;
                }
                if (stringArray[i].compareToIgnoreCase("fixSizes") == 0) {
                    fixSizes = true;
                    continue;
                }
                if (stringArray[i].compareToIgnoreCase("noSSLCheck") == 0) {
                    noSSLCheck = true;
                    continue;
                }
                System.out.println("Invalid argument " + stringArray[i]);
                bl = false;
            }
        }
        if (startYear > endYear) {
            System.out.println("startYear may not be greater than endYear");
            bl = false;
        }
        return bl;
    }

    public static OSType getOperatingSystemType() {
        if (detectedOS == null) {
            String string = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
            detectedOS = string.indexOf("mac") >= 0 || string.indexOf("darwin") >= 0 ? OSType.MacOS : (string.indexOf("win") >= 0 ? OSType.Windows : (string.indexOf("nux") >= 0 ? OSType.Linux : OSType.Other));
        }
        return detectedOS;
    }

    public static String getFileSource(String string) {
        String string2 = "";
        String string3 = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            string3 = bufferedReader.readLine();
            if (string3 != null && string3.startsWith("SOURCE:")) {
                string2 = string3.substring(string3.indexOf(":") + 1);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("Unable to identify source of extract file");
            System.exit(1);
        }
        return string2;
    }

    public static boolean isValidFormat(String string) {
        boolean bl = false;
        for (int i = 0; i < validFormats.length && !bl; ++i) {
            if (string.compareToIgnoreCase(validFormats[i]) != 0) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean isValidEmission(String string) {
        boolean bl = false;
        for (int i = 0; i < validEmissions.length && !bl; ++i) {
            if (string.compareToIgnoreCase(validEmissions[i]) != 0) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean isValidYear(String string) {
        boolean bl = true;
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        if (bl && d < 0.0) {
            bl = false;
        }
        return bl;
    }

    public static void snooze(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Exception exception) {
            System.out.println("Sleep exception");
            System.exit(1);
        }
    }

    public List<String> getDataFromFile(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                arrayList.add(string2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println("Unable to retrieve data from extract file");
            System.exit(1);
        }
        return arrayList;
    }

    public List<String> getDataFromExport(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        CSVReader cSVReader = null;
        String[] stringArray = null;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        String string14 = "";
        String string15 = "";
        String string16 = "";
        Boolean bl = false;
        int n = 0;
        int n2 = 0;
        String string17 = "";
        String string18 = "";
        String string19 = "";
        try {
            cSVReader = new CSVReader(new FileReader(string));
        }
        catch (IOException iOException) {
            System.out.println("Unable to open input file");
            System.exit(1);
        }
        try {
            while ((stringArray = cSVReader.readNext()) != null) {
                String string20 = "";
                try {
                    string20 = stringArray[4];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    continue;
                }
                string19 = stringArray[4];
                YearMonthDay yearMonthDay = this.extractYearMonthDay(string19);
                string2 = yearMonthDay.year;
                string3 = yearMonthDay.month;
                string4 = yearMonthDay.day;
                try {
                    Double.parseDouble(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                string5 = stringArray[2];
                string6 = stringArray[0];
                if (string6.contains("\"")) {
                    string6 = this.escapeQuotes(string6);
                }
                string7 = stringArray[20].replace("<i>", "").replace("</i>", "");
                string8 = stringArray[19];
                string9 = stringArray[27];
                string10 = stringArray[6];
                string11 = stringArray[7];
                string12 = stringArray[3].replaceAll(" ", "");
                string13 = stringArray[9];
                string14 = stringArray[10];
                string15 = stringArray[11].replace("<i>", "").replace("</i>", "");
                string16 = stringArray[32];
                String[] stringArray2 = string16.split("/");
                string12 = string12 + ",All:" + stringArray2[stringArray2.length - 1];
                string17 = "0000000" + ++sequencer;
                string17 = string17.substring(string17.length() - 6);
                bl = true;
                string18 = "STAMP";
                string18 = string18 + separator + string2;
                string18 = string18 + separator + string3;
                string18 = string18 + separator + string4;
                string18 = string18 + separator + string5;
                string18 = string18 + separator + string17;
                string18 = string18 + separator + string6;
                string18 = string18 + separator + string7;
                string18 = string18 + separator + string8;
                string18 = string18 + separator + string9;
                string18 = string18 + separator + string10;
                string18 = string18 + separator + string11;
                string18 = string18 + separator + string15;
                string18 = string18 + separator + string13;
                string18 = string18 + separator + string14;
                string18 = string18 + separator + string12;
                string18 = string18 + separator + string16;
                string18 = string18 + separator + bl;
                string18 = string18 + separator + n;
                string18 = string18 + separator + n2;
                arrayList.add(string18);
            }
        }
        catch (IOException iOException) {
            System.out.println("IOException reading input file");
            System.exit(1);
        }
        catch (CsvValidationException csvValidationException) {
            System.out.println("CsvValidationException reading input file");
            System.exit(1);
        }
        try {
            if (cSVReader != null) {
                cSVReader.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    public YearMonthDay extractYearMonthDay(String string) {
        String string2 = "0000";
        String string3 = "00";
        String string4 = "00";
        int n = 0;
        String[] stringArray = string.split("/");
        if (string.contains("/")) {
            stringArray = string.split("/");
            n = stringArray.length;
        } else if (string.contains("-")) {
            stringArray = string.split("-");
            n = stringArray.length;
        }
        if (stringArray.length == 3) {
            if (stringArray[0].length() == 4) {
                string2 = stringArray[0];
                string3 = stringArray[1];
                string4 = stringArray[2];
            } else {
                string2 = stringArray[2];
                string3 = stringArray[0];
                string4 = stringArray[1];
            }
        } else if (stringArray.length == 2) {
            if (stringArray[0].length() == 4) {
                string2 = stringArray[0];
                string3 = stringArray[1];
            } else {
                string2 = stringArray[21];
                string3 = stringArray[0];
            }
        } else if (stringArray.length == 1) {
            string2 = stringArray[0];
        }
        return new YearMonthDay(string2, string3, string4);
    }

    public String escapeQuotes(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\"') {
                string2 = string2 + String.valueOf('\\');
            }
            string2 = string2 + String.valueOf(string.charAt(i));
        }
        return string2;
    }

    public List<String> collectColnectData(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        String string2 = "";
        int n = 1;
        boolean bl2 = false;
        Document document = null;
        String string3 = "";
        Object var9_9 = null;
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        String string14 = "";
        String string15 = "";
        String string16 = "";
        String string17 = "";
        String string18 = "";
        String string19 = "";
        Boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        String string20 = "";
        int n4 = 0;
        boolean bl4 = false;
        try {
            while (!bl) {
                n4 = 0;
                bl4 = false;
                string2 = string + "/page/" + n;
                while (!bl4) {
                    try {
                        document = Jsoup.connect(string2).timeout(60000).get();
                        bl4 = true;
                    }
                    catch (Exception exception) {
                        if (++n4 > 2) {
                            exception.printStackTrace();
                            System.exit(1);
                        }
                        CommandsFileGenerator.snooze(n4 * 1000);
                    }
                }
                ++n;
                String string21 = document.title();
                String string22 = string21.substring(string21.indexOf("[") + 1);
                String[] stringArray = (string22 = string22.substring(0, string22.indexOf("]"))).split("/");
                if (stringArray[1].compareTo(stringArray[0]) == 0) {
                    bl2 = true;
                }
                Elements elements = document.select("div[class=\"pl-it\"]");
                int n5 = elements.size();
                for (int i = 0; i < n5; ++i) {
                    string4 = "";
                    string9 = "";
                    string8 = "";
                    string5 = "";
                    string6 = "";
                    string7 = "";
                    string10 = "";
                    string11 = "";
                    string12 = "";
                    string13 = "0";
                    string14 = "0";
                    string18 = "";
                    string16 = "";
                    string17 = "";
                    string15 = "";
                    string19 = "";
                    bl3 = false;
                    n2 = 0;
                    n3 = 0;
                    Element element = (Element)elements.get(i);
                    string9 = element.select("h2[class=\"item_header\"]").text();
                    string15 = this.getColnectCatalogCodes(element);
                    string8 = this.getColnectItemValue(element, "a[href*=/series/]");
                    string12 = this.getColnectItemValue(element, "a[href*=color]");
                    string12 = this.fixColor(string12);
                    string5 = this.getColnectItemValue(element, "a[href*=/en/stamps/list/country/" + siteName + "/year/]", "0000");
                    string16 = this.getColnectItemValue(element, "a[href*=format]");
                    string17 = this.getColnectItemValue(element, "a[href*=emission]");
                    string18 = this.getColnectItemValue(element, "a[href*=perforation]");
                    string19 = element.select("img[alt]").first().attr("data-src");
                    string19 = "https" + string19;
                    string18 = string18.replaceAll("\\xc2", "\\xbd");
                    MiscAttrs miscAttrs = this.getColnectMiscAttrs(element.html());
                    string10 = miscAttrs.faceValue;
                    string11 = miscAttrs.currency;
                    string13 = miscAttrs.width;
                    string14 = miscAttrs.height;
                    string6 = miscAttrs.month;
                    string7 = miscAttrs.day;
                    string20 = "0000000" + ++sequencer;
                    string20 = string20.substring(string20.length() - 6);
                    bl3 = true;
                    string3 = "STAMP";
                    string3 = string3 + separator + string5;
                    string3 = string3 + separator + string6;
                    string3 = string3 + separator + string7;
                    string3 = string3 + separator + string8;
                    string3 = string3 + separator + string20;
                    string3 = string3 + separator + string9;
                    string3 = string3 + separator + string10;
                    string3 = string3 + separator + string11;
                    string3 = string3 + separator + string12;
                    string3 = string3 + separator + string13;
                    string3 = string3 + separator + string14;
                    string3 = string3 + separator + string18;
                    string3 = string3 + separator + string16;
                    string3 = string3 + separator + string17;
                    string3 = string3 + separator + string15;
                    string3 = string3 + separator + string19;
                    string3 = string3 + separator + bl3;
                    string3 = string3 + separator + n2;
                    string3 = string3 + separator + n3;
                    arrayList.add(string3);
                }
                if (bl2) {
                    bl = true;
                }
                CommandsFileGenerator.snooze(2000);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return arrayList;
    }

    public String getColnectItemValue(Element element, String string, String string2) {
        String string3 = string2;
        Element element2 = element.select(string).first();
        if (element2 != null) {
            string3 = element2.text();
        }
        return string3;
    }

    public String getColnectItemValue(Element element, String string) {
        return this.getColnectItemValue(element, string, "");
    }

    public String getColnectCatalogCodes(Element element) {
        Object object;
        String string = element.html();
        boolean bl = false;
        int n = 0;
        String string2 = "";
        String string3 = "";
        try {
            object = element.select("h2[class=\"item_header\"]").html();
            object = ((String)object).replace("<a href=\"/en/stamps/stamp/", "");
            String[] stringArray = ((String)object).split("-");
            string3 = stringArray[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = string.split("\n");
        int n2 = ((String[])object).length;
        while (!bl && n < n2) {
            if (((String)object[n]).contains("Catalog codes:")) {
                string2 = ((String)object[n += 3]).trim().replaceAll("<strong>", "").replaceAll("</strong>", "").replaceAll(" ", "");
                bl = true;
            }
            ++n;
        }
        if (string3.compareTo("") != 0) {
            string2 = string2 + ",All:" + string3;
        }
        return string2;
    }

    public MiscAttrs getColnectMiscAttrs(String string) {
        String string2 = "0";
        String string3 = "0";
        String string4 = "";
        String string5 = "";
        String string6 = "00";
        String string7 = "00";
        int n = 3;
        String string8 = "";
        String[] stringArray = null;
        String[] stringArray2 = string.split("\n");
        int n2 = stringArray2.length;
        for (int i = 0; n > 0 && i < n2; ++i) {
            if (stringArray2[i].contains("Face value:")) {
                string8 = stringArray2[i += 3].trim();
                stringArray = string8.split(" ");
                string4 = stringArray[0];
                stringArray = string8.split("\"");
                string5 = stringArray[3];
                --n;
                continue;
            }
            if (stringArray2[i].contains("Size:")) {
                string8 = stringArray2[i += 3].replaceAll(" ", "");
                stringArray = string8.split("x");
                string2 = stringArray[0];
                while (!Character.isDigit(string2.charAt(string2.length() - 1))) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                string3 = stringArray[1];
                while (!Character.isDigit(string3.charAt(string3.length() - 1))) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                --n;
                continue;
            }
            if (!stringArray2[i].matches(".*/en/stamps/list/country/.*/year/.*")) continue;
            string6 = "00";
            string7 = "00";
            stringArray = stringArray2[i].split(">");
            if (stringArray.length > 2) {
                String string9 = stringArray[2].trim();
                while (string9.charAt(0) == '-') {
                    string9 = string9.substring(1);
                }
                stringArray = string9.split("-");
                string6 = stringArray[0];
                if (stringArray.length > 1) {
                    string7 = stringArray[1];
                }
            }
            if (string6.length() < 2) {
                string6 = "0" + string6;
            }
            if (string7.length() < 2) {
                string7 = "0" + string7;
            }
            --n;
        }
        return new MiscAttrs(string2, string3, string4, string5, string6, string7);
    }

    public ImageStatus getColnectImage(String string, String string2) {
        String string3 = string2.replaceAll(" ", "");
        String string4 = imagesDirectory + "/" + string3 + ".jpg";
        return this.getImage(string, string2, string4);
    }

    public List<String> collectStampworldData(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        String string2 = "";
        int n = 1;
        boolean bl2 = false;
        Document document = null;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        String string14 = "";
        String string15 = "";
        String string16 = "";
        String string17 = "";
        String string18 = "";
        String string19 = "";
        Boolean bl3 = false;
        String string20 = "0";
        String string21 = "0";
        String string22 = "";
        try {
            while (!bl) {
                Object object;
                string2 = string + n;
                try {
                    document = Jsoup.connect(string2).timeout(60000).get();
                }
                catch (HttpStatusException httpStatusException) {
                    if (n == 1) {
                        System.out.println("Please check that you have entered the correct site country name");
                    } else {
                        System.out.println("Problem retrieving web page");
                    }
                    System.exit(1);
                }
                ++n;
                Element element = document.getElementById("topBlueBarGroupsCatalogLabel");
                boolean bl4 = false;
                String string23 = element.ownText();
                if (string23 != null && !string23.isEmpty()) {
                    for (Object object2 : string23.toCharArray()) {
                        if (!Character.isDigit((char)object2)) continue;
                        bl4 = true;
                    }
                }
                if (bl4) {
                    string23 = string23.substring(string23.indexOf("page ") + 5);
                    object = (string23 = string23.substring(0, string23.indexOf(")"))).split("/");
                    if (((String)object[1]).compareTo((String)object[0]) == 0) {
                        bl2 = true;
                    }
                } else {
                    bl2 = true;
                }
                object = document.select("div[class=\"container-fluid content_table\"]");
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    Object object3;
                    String string24;
                    Element element2;
                    int n2;
                    Object object2;
                    Elements elements = ((Element)((ArrayList)object).get(i)).children();
                    object2 = elements.size();
                    Element element3 = (Element)elements.get(0);
                    Element element4 = (Element)elements.get(1);
                    Element element5 = (Element)elements.get(2);
                    string5 = "";
                    string6 = "";
                    string7 = "";
                    string8 = "";
                    string18 = "";
                    String string25 = element3.select("a[href]").text();
                    string8 = string25;
                    if (string8.length() > 4 && !Character.isDigit(string8.charAt(7))) {
                        string8 = string8.substring(5);
                    }
                    if (!((n2 = Integer.parseInt(string5 = string25.substring(0, 4))) >= startYear & n2 <= endYear)) continue;
                    String string26 = element3.select("p").text();
                    String[] stringArray = null;
                    String string27 = "";
                    if (string26.contains(".")) {
                        stringArray = string26.split("\\.");
                        string7 = stringArray[0];
                        stringArray = string26.split(" ");
                        string27 = stringArray[1];
                        string6 = this.monthNumber(string27);
                    } else {
                        stringArray = string26.split(" ");
                        string27 = stringArray[0];
                        string6 = this.monthNumber(string27);
                    }
                    if (string5.compareTo(string4) != 0) {
                        string4 = string5;
                    }
                    if ((element2 = element3.select("p").first()) != null && (string24 = element2.text()).contains("Perforation:")) {
                        object3 = string24.substring(string24.indexOf("Perforation:"));
                        string18 = ((String)object3).replace("Perforation:", "").trim();
                    }
                    int n3 = 0;
                    object3 = element5.select("tr[class=\"stamp_tr \"]");
                    n3 = ((ArrayList)object3).size();
                    for (int j = 0; j < n3; ++j) {
                        int n4;
                        string9 = "";
                        string10 = "";
                        string11 = "";
                        string12 = "";
                        string13 = "0";
                        string14 = "0";
                        string16 = "";
                        string17 = "";
                        string15 = "";
                        string19 = "";
                        bl3 = false;
                        string20 = "0";
                        string21 = "0";
                        Elements elements2 = ((Element)((ArrayList)object3).get(j)).select("td");
                        String string28 = ((Element)elements2.get(0)).text();
                        ImageStatus imageStatus = this.getStampworldImage(string28);
                        String string29 = ((Element)elements2.get(1)).text();
                        for (n4 = string29.length() - 1; n4 > 0 && !Character.isDigit(string29.charAt(n4)) && string29.charAt(n4) != '\u00bc' && string29.charAt(n4) != '\u00bd' && string29.charAt(n4) != '\u00be'; --n4) {
                        }
                        string10 = string29.substring(0, n4 + 1);
                        string11 = string29.substring(n4 + 1).trim();
                        string9 = ((Element)elements2.get(5)).text();
                        string12 = ((Element)elements2.get(3)).text();
                        string13 = "0";
                        string14 = "0";
                        string19 = imageStatus.link;
                        bl3 = imageStatus.exists;
                        string20 = String.valueOf(imageStatus.width);
                        string21 = String.valueOf(imageStatus.height);
                        string15 = "Sw:" + string28;
                        string22 = "0000000" + ++sequencer;
                        string22 = string22.substring(string22.length() - 6);
                        string3 = "STAMP";
                        string3 = string3 + separator + string5;
                        string3 = string3 + separator + string6;
                        string3 = string3 + separator + string7;
                        string3 = string3 + separator + string8;
                        string3 = string3 + separator + string22;
                        string3 = string3 + separator + string9;
                        string3 = string3 + separator + string10;
                        string3 = string3 + separator + string11;
                        string3 = string3 + separator + string12;
                        string3 = string3 + separator + string13;
                        string3 = string3 + separator + string14;
                        string3 = string3 + separator + string18;
                        string3 = string3 + separator + string16;
                        string3 = string3 + separator + string17;
                        string3 = string3 + separator + string15;
                        string3 = string3 + separator + string19;
                        string3 = string3 + separator + bl3;
                        string3 = string3 + separator + string20;
                        string3 = string3 + separator + string21;
                        arrayList.add(string3);
                    }
                }
                if (!bl2) continue;
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public ImageStatus getStampworldImage(String string) {
        String string2 = imagesDirectory + "/" + string + ".jpg";
        String string3 = "https://swmedia-4cd6.kxcdn.com/media/catalogue/" + siteName + "/Postage-stamps/" + string + "-s.jpg";
        return this.getImage(string3, string, string2);
    }

    public List<String> collectTouchstampsData(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Document document = Jsoup.connect(string).timeout(60000).get();
            Element element = document.select("select[id=\"year\"]").first();
            Elements elements = element.children();
            int n = elements.size();
            String[] stringArray = element.text().split(" ");
            for (int i = 1; i < n; ++i) {
                String string2 = stringArray[i];
                int n2 = Integer.parseInt(string2);
                if (!(n2 >= startYear & n2 <= endYear)) continue;
                List<String> list = this.getTouchstampsYear(string + "/" + string2);
                arrayList.addAll(list);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return arrayList;
    }

    public List<String> getTouchstampsYear(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        String string2 = null;
        int n2 = 1;
        while (n2 > 0) {
            string2 = string + "?page=" + n;
            try {
                Document document = Jsoup.connect(string2).timeout(60000).get();
                Element element = document.select("table[class=\"table table-striped table-condensed\"]").first();
                Elements elements = element.children();
                Elements elements2 = ((Element)elements.get(1)).children();
                n2 = elements2.size();
                for (int i = 0; i < n2; ++i) {
                    Element element2 = (Element)elements2.get(i);
                    Elements elements3 = element2.children();
                    String string3 = ((Element)elements3.get(1)).text();
                    String string4 = ((Element)elements3.get(2)).text();
                    String[] stringArray = ((Element)elements3.get(2)).html().split("\"");
                    String string5 = stringArray[1];
                    String[] stringArray2 = string3.split("/");
                    String string6 = stringArray2[2];
                    String string7 = stringArray2[0];
                    String string8 = stringArray2[1];
                    List<String> list = this.getTouchstampsStamps(string5, string6, string7, string8, string4);
                    arrayList.addAll(list);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
            ++n;
        }
        return arrayList;
    }

    public List<String> getTouchstampsStamps(String string, String string2, String string3, String string4, String string5) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string6 = "https://touchstamps.com" + string;
        try {
            String string7 = "";
            String string8 = "";
            String string9 = "";
            String string10 = "";
            String string11 = string2;
            String string12 = string3;
            String string13 = string4;
            String string14 = string5;
            String string15 = "";
            String string16 = "";
            String string17 = "";
            String string18 = "";
            String string19 = "";
            String string20 = "";
            String string21 = "";
            String string22 = "";
            String string23 = "";
            String string24 = "";
            String string25 = "";
            boolean bl = true;
            String string26 = "";
            String string27 = "";
            String string28 = "";
            Document document = Jsoup.connect(string6).timeout(60000).get();
            Elements elements = document.select("article[class=\"contentColumn item\"]");
            int n = elements.size();
            for (int i = 0; i < n; ++i) {
                int n2;
                Object object;
                string15 = "";
                string16 = "";
                string17 = "";
                string18 = "";
                string19 = "0";
                string20 = "0";
                string24 = "";
                string22 = "";
                string23 = "";
                string21 = "";
                string25 = "";
                bl = false;
                string26 = "0";
                string27 = "0";
                Element element = (Element)elements.get(i);
                string15 = element.select("header[class=\"round-header\"]").text();
                String string29 = element.select("section[class=\"right\"]").html();
                if (string29.contains("image_url")) {
                    string7 = string29.substring(string29.indexOf("image_url") + 10);
                    string7 = string7.substring(0, string7.indexOf("\""));
                    object = string7.split("/");
                    int n3 = ((String[])object).length;
                    string8 = object[n3 - 1];
                } else {
                    string7 = string29.substring(string29.indexOf("src") + 6);
                    string7 = string7.substring(0, string7.indexOf(" ") - 1);
                    string8 = string7.substring(15);
                }
                object = this.getTouchstampsImage(string7, string8);
                string25 = object.link;
                bl = object.exists;
                string26 = String.valueOf(object.width);
                string27 = String.valueOf(object.height);
                string21 = "Ts:" + string8;
                Element element2 = (Element)element.select("table[class=\"table table-striped table-condensed\"]").get(0);
                string22 = element2.select("tr:contains(Format:)").text().replaceAll("Format: ", "");
                string24 = element2.select("tr:contains(Perforation:)").text().replaceAll("Perforation: ", "");
                string23 = element2.select("tr:contains(Emission:)").text().replaceAll("Emission: ", "");
                String string30 = element2.select("td[itemprop=\"offers\"]").text();
                for (n2 = string30.length() - 1; n2 > 0 && !Character.isDigit(string30.charAt(n2)) && string30.charAt(n2) != '\u00bc' && string30.charAt(n2) != '\u00bd' && string30.charAt(n2) != '\u00be'; --n2) {
                }
                string16 = string30.substring(0, n2 + 1);
                string17 = string30.substring(n2 + 1).trim();
                String string31 = element.select("section[class=\"ico-toolbar\"]").select("div[class=\"btn-group\"]").first().html();
                String string32 = string31.substring(string31.indexOf("title=\"Details\" href=\"") + 22);
                String[] stringArray = string32.split("\"");
                string32 = stringArray[0];
                string9 = this.getTouchstampsDetails(string32);
                String[] stringArray2 = string9.split(separator);
                string19 = stringArray2[0];
                string20 = stringArray2[1];
                string28 = "0000000" + ++sequencer;
                string28 = string28.substring(string28.length() - 6);
                String string33 = "STAMP";
                string33 = string33 + separator + string11;
                string33 = string33 + separator + string12;
                string33 = string33 + separator + string13;
                string33 = string33 + separator + string14;
                string33 = string33 + separator + string28;
                string33 = string33 + separator + string15;
                string33 = string33 + separator + string16;
                string33 = string33 + separator + string17;
                string33 = string33 + separator + string18;
                string33 = string33 + separator + string19;
                string33 = string33 + separator + string20;
                string33 = string33 + separator + string24;
                string33 = string33 + separator + string22;
                string33 = string33 + separator + string23;
                string33 = string33 + separator + string21;
                string33 = string33 + separator + string25;
                string33 = string33 + separator + bl;
                string33 = string33 + separator + string26;
                string33 = string33 + separator + string27;
                arrayList.add(string33);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return arrayList;
    }

    public String getTouchstampsDetails(String string) {
        String string2 = "https://touchstamps.com" + string;
        String string3 = "0" + separator + "0";
        try {
            String string4 = "0";
            String string5 = "0";
            Element element = null;
            Document document = Jsoup.connect(string2).timeout(60000).get();
            element = document.select("span[itemprop=\"width\"]").first();
            if (element != null) {
                string4 = element.text();
            }
            if ((element = document.select("span[itemprop=\"height\"]").first()) != null) {
                string5 = element.text();
            }
            string3 = string4 + separator + string5;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return string3;
    }

    public ImageStatus getTouchstampsImage(String string, String string2) {
        String string3 = imagesDirectory + "/" + string2 + ".jpg";
        return this.getImage("touchstamps.com/" + string, string2, string3);
    }

    public ImageStatus getImage(String string, String string2, String string3) {
        Object object;
        Object object2;
        if (string2.compareTo("") == 0) {
            return new ImageStatus("", false, 0, 0);
        }
        String string4 = "";
        string4 = noSSLCheck ? "curl --ssl-no-revoke -L -o " + string3 + " " + string : "curl -L -o " + string3 + " " + string;
        int n = 0;
        int n2 = 0;
        boolean bl = true;
        try {
            object2 = new ProcessBuilder(string4.split(" "));
            object = ((ProcessBuilder)object2).start();
            int n3 = ((Process)object).waitFor();
        }
        catch (IOException iOException) {
            System.out.println("IOException executing curl for imageURL");
            iOException.printStackTrace();
            System.exit(1);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("InterruptedException executing curl for imageURL");
            interruptedException.printStackTrace();
            System.exit(1);
        }
        object2 = new File(string3);
        try {
            object = ImageIO.read((File)object2);
            n = ((BufferedImage)object).getWidth();
            n2 = ((BufferedImage)object).getHeight();
        }
        catch (IOException iOException) {
            System.out.println("IOException getting image properties");
            iOException.printStackTrace();
            System.exit(1);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            bl = this.isValidJpeg(string3);
        }
        if (!bl && ((File)object2).exists()) {
            ((File)object2).delete();
        }
        return new ImageStatus(string, bl, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidJpeg(String string) {
        boolean bl = true;
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(string)));
            if (((DataInputStream)filterInputStream).readInt() != -2555936) {
                bl = false;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        catch (IOException iOException) {
            bl = false;
        }
        finally {
            try {
                filterInputStream.close();
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public String monthNumber(String string) {
        if ((string = string.toUpperCase()).equals("JANUARY")) {
            return "01";
        }
        if (string.equals("FEBRUARY")) {
            return "02";
        }
        if (string.equals("MARCH")) {
            return "03";
        }
        if (string.equals("APRIL")) {
            return "04";
        }
        if (string.equals("MAY")) {
            return "05";
        }
        if (string.equals("JUNE")) {
            return "06";
        }
        if (string.equals("JULY")) {
            return "07";
        }
        if (string.equals("AUGUST")) {
            return "08";
        }
        if (string.equals("SEPTEMBER")) {
            return "09";
        }
        if (string.equals("OCTOBER")) {
            return "10";
        }
        if (string.equals("NOVEMBER")) {
            return "11";
        }
        if (string.equals("DECEMBER")) {
            return "12";
        }
        return "00";
    }

    public String fixColor(String string) {
        string = string.replaceAll("'.'", "");
        string = string.replaceAll("Dk", "Dark");
        string = string.replaceAll("Grn", "Green");
        string = string.replaceAll("grn", "green");
        string = string.replaceAll("Brn", "Grown");
        string = string.replaceAll("brn", "brown");
        string = string.replaceAll("Org", "Orange");
        string = string.replaceAll("org", "orange");
        string = string.replaceAll("Blk", "Black");
        string = string.replaceAll("blk", "black");
        string = string.replaceAll("Multi", "Multicolor");
        string = string.replaceAll("multi", "multicolor");
        string = string.replaceAll("Car", "Carmine");
        string = string.replaceAll("CarCarmine", "Carmine");
        string = string.replaceAll("car", "carmine");
        string = string.replaceAll("carcarmine", "carmine");
        string = string.replaceAll("carminemine", "carmine");
        string = string.replaceAll("Carminemine", "Carmine");
        string = string.replaceAll("Ultra", "Ultramarine");
        string = string.replaceAll("Ultramarinemarine", "Ultramarine");
        string = string.replaceAll("ultra", "ultramarine");
        string = string.replaceAll("ultramarinemarine", "ultramarine");
        string = string.replaceAll("Pur", "Purple");
        string = string.replaceAll("Purpleple", "Purple");
        string = string.replaceAll("pur", "purple");
        string = string.replaceAll("purpleple", "Purple");
        string = string.replaceAll("Vio", "Violet");
        string = string.replaceAll("Violetlet", "Violet");
        string = string.replaceAll("vio", "violet");
        string = string.replaceAll("violetlet", "violet");
        string = string.replaceAll("Yel", "Yellow");
        string = string.replaceAll("Yellowlow", "Yellow");
        string = string.replaceAll("yel", "yellow");
        string = string.replaceAll("yellowlow", "yellow");
        string = string.replaceAll("Brt", "Bright");
        string = string.replaceAll("brt", "bright");
        string = string.replaceAll("Dp", "Deep");
        string = string.replaceAll("dp", "deep");
        string = string.replaceAll("Br ", "Bright ");
        string = string.replaceAll("br ", "bright ");
        string = string.replaceAll("Lt", "Light");
        string = string.replaceAll(" lt", " light");
        string = string.replaceAll("Prus ", "Prussian ");
        string = string.replaceAll("prus ", "prussian ");
        return string;
    }

    public void saveStampData(String string, List<String> list, String string2) {
        try {
            Path path = Paths.get(string, new String[0]);
            File file = new File(string);
            if (file.exists()) {
                file.setWritable(true);
            }
            Files.deleteIfExists(path);
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write("SOURCE:" + dataSource + System.lineSeparator());
            for (String string3 : list) {
                fileWriter.write(string3 + System.lineSeparator());
            }
            fileWriter.close();
            file.setReadOnly();
        }
        catch (Exception exception) {
            System.out.println("Unable to save extract file ... continuing");
        }
    }

    public void createAlbum(String string, List<String> list) {
        String string2 = "";
        String[] stringArray = null;
        boolean bl = false;
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        String string14 = "";
        String string15 = "";
        String string16 = "";
        String string17 = "";
        String string18 = "";
        String string19 = "";
        String string20 = "";
        String string21 = "";
        String string22 = "";
        String string23 = "";
        String string24 = "";
        String string25 = "";
        String string26 = "";
        String string27 = "";
        SeriesInfo seriesInfo = null;
        int n = 1;
        boolean bl2 = false;
        String string28 = "0";
        String string29 = "0";
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(string));
        }
        catch (IOException iOException) {
            System.out.println("Unable to open output file");
            System.exit(1);
        }
        this.writeGlobals(bufferedWriter);
        for (int i = 0; i < list.size(); ++i) {
            string2 = list.get(i);
            if (!string2.startsWith("STAMP")) continue;
            stringArray = string2.split(separator);
            string3 = stringArray[1];
            string4 = stringArray[2];
            string5 = stringArray[3];
            string6 = stringArray[4];
            string7 = stringArray[5];
            string8 = stringArray[6];
            string9 = stringArray[7];
            string10 = stringArray[8];
            string11 = stringArray[9];
            string12 = stringArray[10];
            string13 = stringArray[11];
            string14 = stringArray[12];
            string15 = stringArray[13];
            string16 = stringArray[14];
            string17 = stringArray[15];
            string18 = stringArray[16];
            string19 = stringArray[17];
            string20 = stringArray[18];
            string21 = stringArray[19];
            string11 = this.fixColor(string11);
            string26 = catalogName.compareTo("") == 0 ? string7 : this.getCatalogNum(string17, false);
            string27 = string3 + string4 + string5;
            if (string26.compareTo("") == 0 || string26.compareTo("Unlisted") == 0 || !this.isSelectedFormat(string15) || !this.isSelectedEmission(string16)) continue;
            if (string3.compareTo(string22) != 0) {
                this.newPage(bufferedWriter);
                this.newYear(bufferedWriter, string3);
                string28 = "0";
                seriesInfo = this.getSeriesInfo(list, i, string28, string29);
                n = seriesInfo.count;
                bl2 = seriesInfo.multiPerf;
                string28 = seriesInfo.width;
                string29 = seriesInfo.height;
                this.newSeries(bufferedWriter, string6, string3, string4, string5, n, bl2, string14);
                string22 = string3;
                string23 = string6;
                string25 = string14;
                string24 = string27;
            } else if (string6.compareTo(string23) != 0 || string27.compareTo(string24) != 0) {
                string28 = "0";
                seriesInfo = this.getSeriesInfo(list, i, string28, string29);
                n = seriesInfo.count;
                bl2 = seriesInfo.multiPerf;
                string28 = seriesInfo.width;
                string29 = seriesInfo.height;
                this.newSeries(bufferedWriter, string6, string3, string4, string5, n, bl2, string14);
                string23 = string6;
                string24 = string27;
                string25 = string14;
                string24 = string27;
            }
            if (fixSizes && n > 1 && string12.compareTo("0") == 0) {
                string12 = string28;
                string13 = string29;
            }
            string26 = this.getCatalogNum(string17, true);
            this.addStamp(bufferedWriter, string3, string8, string9, string10, string11, bl2, string14, string12, string13, string26, string19);
        }
        try {
            bufferedWriter.close();
            CommandsFileGenerator.snooze(500);
        }
        catch (IOException iOException) {
            System.out.println("Unable to close output file");
            System.exit(1);
        }
    }

    public boolean isSelectedFormat(String string) {
        boolean bl = false;
        if (formats.size() == 0) {
            bl = true;
        } else {
            for (int i = 0; !bl && i < formats.size(); ++i) {
                if (string.compareToIgnoreCase(formats.get(i)) != 0) continue;
                bl = true;
            }
        }
        return bl;
    }

    public String getCatalogNum(String string, boolean bl) {
        String string2 = "";
        String string3 = catalogName;
        if (bl && (dataSource.compareTo("colnect") == 0 || fileSource.compareTo("colnect") == 0)) {
            string3 = "All";
        }
        if (string.contains(string3)) {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length && string2.compareTo("") == 0; ++i) {
                if (!stringArray[i].startsWith(string3)) continue;
                string2 = stringArray[i].substring(stringArray[i].indexOf(":") + 1);
            }
        }
        return string2;
    }

    public boolean isSelectedEmission(String string) {
        boolean bl = false;
        if (emissions.size() == 0) {
            bl = true;
        } else {
            for (int i = 0; !bl && i < emissions.size(); ++i) {
                if (string.compareToIgnoreCase(emissions.get(i)) != 0) continue;
                bl = true;
            }
        }
        return bl;
    }

    public SeriesInfo getSeriesInfo(List<String> list, int n, String string, String string2) {
        int n2 = 1;
        boolean bl = false;
        int n3 = list.size();
        String string3 = "";
        String[] stringArray = null;
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        boolean bl2 = false;
        String string14 = string;
        String string15 = string2;
        string3 = list.get(n);
        stringArray = string3.split(separator);
        string4 = stringArray[1] + stringArray[2] + stringArray[3];
        string5 = stringArray[4];
        string6 = stringArray[12];
        if (string5.compareTo("") != 0) {
            while (!bl2 && n < n3 - 1) {
                string3 = list.get(++n);
                stringArray = string3.split(separator);
                string7 = stringArray[1] + stringArray[2] + stringArray[3];
                string8 = stringArray[4];
                string9 = stringArray[12];
                string10 = stringArray[13];
                string11 = stringArray[14];
                string12 = stringArray[10];
                string13 = stringArray[11];
                if (string8.compareTo(string5) != 0 || string7.compareTo(string4) != 0) {
                    bl2 = true;
                    continue;
                }
                if (!this.isSelectedFormat(string10) || !this.isSelectedEmission(string11)) continue;
                ++n2;
                if (string9.compareTo(string6) != 0 && string9.compareTo("") != 0) {
                    bl = true;
                }
                if (string.compareTo("0") != 0) continue;
                string14 = string12;
                string15 = string13;
            }
        }
        return new SeriesInfo(n2, bl, string14, string15);
    }

    public void writeGlobals(BufferedWriter bufferedWriter) {
        this.writeLine(bufferedWriter, "################################################################################");
        this.writeLine(bufferedWriter, "# " + albumName);
        this.writeLine(bufferedWriter, "################################################################################");
        this.writeLine(bufferedWriter, "");
        this.writeLine(bufferedWriter, "ALBUM_PAGES_SIZE  (215.9 279.4) #Set the page to US Letter (8.5 x 11)");
        this.writeLine(bufferedWriter, "#ALBUM_PAGES_SIZE (210.0 297.0) #Setting for A4");
        this.writeLine(bufferedWriter, "");
        this.writeLine(bufferedWriter, "ALBUM_PAGES_MARGINS  (15.0 10.0 10.0 10.0 )");
        this.writeLine(bufferedWriter, "");
        this.writeLine(bufferedWriter, "ALBUM_PAGES_BORDER (0.5 0.1 0.0 3.0)    #two line border");
        this.writeLine(bufferedWriter, "#ALBUM_PAGES_BORDER3  (0.1 0.0 0.0 3.0) #single line border");
        this.writeLine(bufferedWriter, "");
        this.writeLine(bufferedWriter, "ALBUM_PAGES_TITLE (TB 18 \"" + albumName + "\")");
        this.writeLine(bufferedWriter, "");
        this.writeLine(bufferedWriter, "ALBUM_PAGES_SPACING (5.0 3.0)");
        this.writeLine(bufferedWriter, "");
        this.writeLine(bufferedWriter, "#ALBUM_PAGES_NUMBER (TN 10 R)");
        this.writeLine(bufferedWriter, "");
        this.writeLine(bufferedWriter, "ALBUM_STAMP_NEW_IMG_SETTING (6.0 6.0 true)");
        this.writeLine(bufferedWriter, "");
        this.writeLine(bufferedWriter, "ROW_ALIGN_MIDDLE");
        this.writeLine(bufferedWriter, "");
        this.writeLine(bufferedWriter, "# The stamp boxes in this album are sized approximately");
        this.writeLine(bufferedWriter, "# 4mm larger than the actual stamps giving a 2mm border");
        this.writeLine(bufferedWriter, "# To have the boxes drawn the actual stamp size use");
        this.writeLine(bufferedWriter, "#STAMP_BOXES_SIZE_ADJUST(-4.0)");
        this.writeLine(bufferedWriter, "# To increase the border, e.g by 1mm use STAMP_BOXES_SIZE_ADJUST(2.0)");
        this.writeLine(bufferedWriter, "STAMP_BOXES_SIZE_ADJUST (0)");
    }

    public void newPage(BufferedWriter bufferedWriter) {
        String string = "################################################################################";
        this.writeLine(bufferedWriter, string);
        this.writeLine(bufferedWriter, "PAGE_START");
        rowsWritten = 0;
        stampsWritten = 0;
        usedWidth = 0;
        usedHeight = 14;
        maxRowHeight = 0;
    }

    public void newRow(BufferedWriter bufferedWriter, String string) {
        if ((usedHeight += maxRowHeight) + 43 > 245) {
            this.newPage(bufferedWriter);
            this.newYear(bufferedWriter, string);
        }
        this.writeLine(bufferedWriter, "ROW_START_FS (TN 6 0.1 5.0)");
        ++rowsWritten;
        stampsWritten = 0;
        usedWidth = 0;
        usedHeight += maxRowHeight;
        maxRowHeight = 0;
    }

    public void newYear(BufferedWriter bufferedWriter, String string) {
        this.writeLine(bufferedWriter, "PAGE_TEXT_CENTRE_VSPACE (TN 10 \"" + string + "\" 3.0)");
        usedHeight += 7;
    }

    public void newSeries(BufferedWriter bufferedWriter, String string, String string2, String string3, String string4, int n, boolean bl, String string5) {
        String string6;
        if (rowsWritten == 4) {
            this.newPage(bufferedWriter);
            this.newYear(bufferedWriter, string2);
        } else if (usedHeight + maxRowHeight + 43 > 245) {
            this.newPage(bufferedWriter);
            this.newYear(bufferedWriter, string2);
        } else {
            int n2 = (n + 3) / 4;
            if (rowsWritten + n2 > 4) {
                this.newPage(bufferedWriter);
                this.newYear(bufferedWriter, string2);
            }
        }
        String string7 = string;
        if (string.contains("\"")) {
            string7 = this.escapeQuotes(string);
        }
        if ((string6 = string4).startsWith("0")) {
            string6 = string6.substring(1);
        }
        String string8 = "";
        if (string2.compareTo("0000") != 0 && string3.compareTo("00") != 0 && string4.compareTo("00") != 0) {
            string8 = monthNames[Integer.parseInt(string3)] + " " + string6 + ", " + string2;
        } else if (string2.compareTo("0000") != 0 && string3.compareTo("00") != 0 && string4.compareTo("00") == 0) {
            string8 = monthNames[Integer.parseInt(string3)] + ", " + string2;
        } else if (string2.compareTo("0000") != 0 && string3.compareTo("00") == 0 && string4.compareTo("00") == 0) {
            string8 = string2;
        }
        if (string8.compareTo("") != 0) {
            this.writeLine(bufferedWriter, "PAGE_TEXT_CENTRE_VSPACE (TN 10 \"" + string8 + "\" 0.5)");
        }
        this.writeLine(bufferedWriter, "PAGE_TEXT_CENTRE_VSPACE (TN 10 \"" + string7 + "\" 0.5)");
        if (!bl && string5.compareTo("") != 0) {
            this.writeLine(bufferedWriter, "PAGE_TEXT_CENTRE_VSPACE (TN 10 \"Perforation " + string5 + "\" 2.0)");
        } else {
            this.writeLine(bufferedWriter, "PAGE_TEXT_CENTRE_VSPACE (TN 10 \"\" 1.5)");
        }
        this.newRow(bufferedWriter, string2);
        usedHeight += 13;
        maxRowHeight = 0;
    }

    public void addStamp(BufferedWriter bufferedWriter, String string, String string2, String string3, String string4, String string5, boolean bl, String string6, String string7, String string8, String string9, String string10) {
        Object object;
        String string11 = "30.0";
        String string12 = "30.0";
        int n = 0;
        String string13 = "";
        String string14 = string3;
        if (string7.length() > 0 && string8.length() > 0) {
            int n2;
            if (string7.compareTo("0") != 0) {
                if (string7.contains(".")) {
                    n = string7.indexOf(".");
                    string13 = string7.substring(0, n);
                    n2 = Integer.valueOf(string13) + 4;
                    string11 = Integer.toString(n2);
                    string11 = string11 + string7.substring(n);
                } else {
                    n2 = Integer.valueOf(string7) + 4;
                    string11 = Integer.toString(n2) + ".0";
                }
            }
            if (string8.compareTo("0") != 0) {
                if (string8.contains(".")) {
                    n = string8.indexOf(".");
                    string13 = string8.substring(0, n);
                    n2 = Integer.valueOf(string13) + 4;
                    string12 = Integer.toString(n2);
                    string12 = string12 + string8.substring(n);
                } else {
                    n2 = Integer.valueOf(string8) + 4;
                    string12 = Integer.toString(n2) + ".0";
                }
            }
        }
        String string15 = string9.replaceAll(" ", "");
        String string16 = string2;
        if (string2.contains("\"")) {
            string16 = this.escapeQuotes(string2);
        }
        if (string4.compareTo("") != 0) {
            string14 = string3 + " " + string4;
            object = null;
            for (int i = 0; i < currencies.size(); ++i) {
                object = currencies.get(i).split(":");
                if (string4.compareToIgnoreCase(object[1]) != 0) continue;
                string14 = object[3].compareToIgnoreCase("pre") == 0 ? object[2] + string3 : string3 + object[2];
            }
        }
        object = "";
        String string17 = "";
        if (bl) {
            string17 = "\\nPerforation " + string6;
        }
        String string18 = "";
        double d = font.getStringBounds(string16, frc).getWidth() / 2.835;
        if (d > Double.valueOf(string11)) {
            String[] stringArray = string16.split(" ");
            double[] dArray = new double[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                dArray[i] = font.getStringBounds(stringArray[i], frc).getWidth() / 2.835;
            }
            double d2 = 0.0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (d2 + dArray[i] < Double.valueOf(string11)) {
                    string18 = string18 + " " + stringArray[i];
                    d2 += dArray[i];
                    continue;
                }
                string18 = string18 + "\\n" + stringArray[i];
                d2 = 0.0;
            }
        } else {
            string18 = string16;
        }
        object = noImages ? "STAMP_ADD (" + string11 + " " + string12 + " \"" + string18 + "\\n" + string14 + " " + string5 + string17 + "\" \"\" \"\" \"\")" : (string10.compareToIgnoreCase("false") == 0 || string15.compareToIgnoreCase("Unlisted") == 0 ? "STAMP_ADD (" + string11 + " " + string12 + " \"Image\\nNot\\nAvailable\" \"\" \"" + string18 + "\\n" + string14 + " " + string5 + string17 + "\" \"\")" : "STAMP_ADD_IMG (" + string11 + " " + string12 + " \"images/" + string15 + ".jpg\" \"\" \"" + string18 + "\\n" + string14 + " " + string5 + string17 + "\" \"\")");
        if (stampsWritten == 4 || Double.valueOf(string11).intValue() > 90 || usedWidth + 5 + Double.valueOf(string11).intValue() > 180) {
            this.newRow(bufferedWriter, string);
        }
        this.writeLine(bufferedWriter, (String)object);
        ++stampsWritten;
        usedWidth = usedWidth + 5 + Double.valueOf(string11).intValue();
        if (Double.valueOf(string12).intValue() > maxRowHeight) {
            maxRowHeight = Double.valueOf(string12).intValue();
        }
    }

    public void writeLine(BufferedWriter bufferedWriter, String string) {
        try {
            bufferedWriter.write(string);
            bufferedWriter.newLine();
        }
        catch (IOException iOException) {
            System.out.println("Error writing output file");
            System.exit(1);
        }
    }

    static enum OSType {
        Windows,
        MacOS,
        Linux,
        Other;

    }

    class YearMonthDay {
        String year;
        String month;
        String day;

        public YearMonthDay(String string, String string2, String string3) {
            this.year = string;
            this.month = string2;
            this.day = string3;
        }
    }

    class SeriesInfo {
        public int count;
        public boolean multiPerf;
        String width;
        String height;

        public SeriesInfo(int n, boolean bl, String string, String string2) {
            this.count = n;
            this.multiPerf = bl;
            this.width = string;
            this.height = string2;
        }
    }

    class ImageStatus {
        public String link;
        public boolean exists;
        public int width;
        public int height;

        public ImageStatus(String string, boolean bl, int n, int n2) {
            this.link = string;
            this.exists = bl;
            this.width = n;
            this.height = n2;
        }
    }

    class MiscAttrs {
        public String width;
        public String height;
        public String faceValue;
        public String currency;
        public String month;
        public String day;

        public MiscAttrs(String string, String string2, String string3, String string4, String string5, String string6) {
            this.width = string;
            this.height = string2;
            this.faceValue = string3;
            this.currency = string4;
            this.month = string5;
            this.day = string6;
        }
    }
}

